<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.css')); ?>" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body-content'); ?>
    <div class="page-wrapper">
        <!-- Page Title -->
        <div class="page-title">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h2 class="page-title-text"></h2>
                </div>
                <div class="col-sm-6 text-right">
                    <div class="breadcrumbs">
                        <ul>
                            <li><a href="#">Home</a></li>
                            <li>Dashboard</li>
                            <li>Order</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page Body -->
        <div class="page-body">
            <div class="row">

                <div class="col-12">
                    <div class="panel panel-default">

                        <div class="panel-head"></div>

                        <div class="panel-body">
                            <?php if( session()->has('message') ): ?>
                                <div class="alert alert-icon alert-success alert-dismissible fade show">
                                    <div class="alert--icon">
                                        <i class="fa fa-check"></i>
                                    </div>
                                    <div class="alert-text">
                                        <strong>Well done!</strong> <?php echo e(session('message')); ?>

                                    </div>
                                    <button type="button" class="close" data-dismiss="alert">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            <?php endif; ?>
                            <div class="table-responsive">
                                <table id="all_orders_dt" class="table table-head-bg table-head-primary table table-striped table-bordered basic-datatable" cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Date</th>
                                        <th>Reference</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Product</th>
                                        <th>Size</th>
                                        <th>Price</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(++$key); ?></td>
                                            <td> <?php echo date('d/m/Y - H:i', strtotime($order->orderCreatedDate));?></td>
                                            <td><?php echo e(strtoupper($order->reference)); ?></td>
                                            <td><?php echo e($order->user->first_name); ?> <?php echo e($order->user->last_name); ?></td>
                                            <td><?php echo e($order->user->email); ?></td>
                                            <?php if($order->count > 1): ?>
                                                <td style="color:red;"> Multiple</td>
                                                <td style="color:red;"> Multiple</td>
                                            <?php else: ?>
                                                <td><?php echo e($order->product_name); ?> </td>
                                                <td> <?php echo e($order->size); ?></td>
                                            <?php endif; ?>

                                            <td>£<?php echo e(number_format((float)$order->final_price, 2, '.', '')); ?></td>

                                            <td class="d-flex">
                                                <a href="<?php echo e(route('product.by.id', ['id' => $order->product_id])); ?>" class="btn btn-primary btn-sm m-1">Product</a>
                                                <a href="<?php echo e(route('allorder.detail.buyer', ['id' => $order->id])); ?>" class="btn btn-primary btn-sm m-1">View</a>
                                                <a onclick="deleteRow(this, <?php echo e($order->id); ?>)" href="javascript:void(0);" class="btn btn-danger btn-sm m-1">Delete</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript" src="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.js')); ?>"></script>

    <script>

        $(document).ready(function () {
            $('#all_orders_dt').DataTable({
                order: [[1, 'ASC']],
            });
        });

        function deleteRow(button, id) {

            let confirmed = confirm("Are you sure you want to delete this order?");

            if (confirmed) {
                button.disabled = true;
                window.location = `order-delete/${id}`;
            }
        }

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/resources/views/admin/order/order-index.blade.php ENDPATH**/ ?>